﻿using System.Runtime.Serialization;
using Microsoft.ProgramSynthesis.Utils.JetBrains.Annotations;
using Newtonsoft.Json;
using static NLToCode.Evaluation.Configuration;

namespace NLToCode.Evaluation {
    [DataContract]
    public class Configuration {
        public enum OperationMode { Execute, Metrics, Unroll };

        public enum LanguageMode { Pandas, Mashup };

        public enum FileReader { Json, Jsonl }

        [DataMember, UsedImplicitly]
        public string InputPath;

        [DataMember, UsedImplicitly]
        public string OutputPath;

        [DataMember, UsedImplicitly]
        public OperationMode Mode;

        [DataMember, UsedImplicitly]
        public LanguageMode Language;

        [DataMember, UsedImplicitly]
        public Logger.Priority LogLevel;

        [DataMember, UsedImplicitly]
        public FileReader FileType;

        public static Configuration Parse(string path) {
            string jsonText = File.ReadAllText(path);
            return JsonConvert.DeserializeObject<Configuration>(jsonText);

        }

        public static Configuration Parse(string[] args) {
            var inputPath = string.Empty;
            var outputPath = string.Empty;
            var mode = OperationMode.Execute;
            var logLevel = Logger.Priority.Info;
            var languageMode = LanguageMode.Mashup;
            var fileType = FileReader.Json;

            foreach (var arg in args) {
                string[] tokens = arg.Split('=');

                if (tokens.Length == 2) {
                    switch (tokens[0]) {
                        case "InputPath":
                            inputPath = tokens[1];
                            break;
                        case "Mode":
                            mode = (OperationMode) Enum.Parse(typeof(OperationMode), tokens[1]);
                            break;
                        case "OutputPath":
                            outputPath = tokens[1];
                            break;
                        case "LogLevel":
                            logLevel = (Logger.Priority) Enum.Parse(typeof(Logger.Priority), tokens[1]);
                            break;
                        case "LanguageMode":
                            languageMode = (LanguageMode) Enum.Parse(typeof(LanguageMode), tokens[1]);
                            break;
                        case "Reader":
                            fileType = (FileReader) Enum.Parse(typeof(FileReader), tokens[1]);
                            break;
                    }
                }
            }

            return new Configuration { InputPath = inputPath, Mode = mode, OutputPath = outputPath, LogLevel = logLevel, Language = languageMode, FileType = fileType };
        }

    }
}
